<?php

namespace App\Modes\Insurances;

use Illuminate\Database\Eloquent\Model;

class Insurance extends Model 
{

    protected $table = 'insurances';
    public $timestamps = true;

    public function doctors()
    {
        return $this->hasMany('DoctorInsurances', 'insurance_id');
    }

    public function notes()
    {
        return $this->hasMany('InsuranceNotes', 'insurance_id');
    }

    public function patients()
    {
        return $this->hasMany('PatientInsurance', 'insurance_id');
    }

    public function updatedUser()
    {
        return $this->belongsTo('User', 'id');
    }

    public function contacts()
    {
        return $this->hasMany('InsurancesContacts', 'insurance_id');
    }

}